#!/bin/sh

function verifyedid()
{

    index=$1
    index=$((index-1))
    
    if [ "$3" == "" ]; then

        REDIRECTERRORS=/dev/null

    else

        REDIRECTERRORS=$3

    fi
    
    SV2DRIVER=$(/usr/local/bin/MtxBoardInfo >& /dev/null ; echo $?)

    if [ ${SV2DRIVER} -eq "0" ]; then
        /usr/local/bin/MtxEdidFlasher -c $index -v -f $2 > /tmp/edid.txt 2> ${REDIRECTERRORS}
    else
        ./InitMemContext >& /dev/null
        ./MtxEdidFlasher-NoDrv -c $index -v -f $2 > /tmp/edid.txt 2> ${REDIRECTERRORS}
    fi 
    cat /tmp/edid.txt | grep -q "EDIDs match"
}

if [ "$1" == "" ] || [ "$1" == "--help" ]; then

    echo ""
    echo "Verifies that EDID file matches EDID from SV2-based device. Error level zero indicates a match."
    echo ""
    echo "Usage:"
    echo "verifyedid.sh <one-based connector index> <path to EDID file>"
    echo ""
    echo "Example:"
    echo "verifyedid.sh 1 /tmp/firmwareupdate/Edid-Mura-1.bin"
    echo ""

else
    n=1
    until [ $n -ge 4 ]; do verifyedid $@ && break; n=$[$n+1]; sleep 1; done
    cat /tmp/edid.txt | grep "EDIDs match" > /dev/null
    echo $?
fi
